<?php
include 'koneksi.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['tambah'])) {
    $id_obat = mysqli_real_escape_string($conn, $_POST['id_obat']);
    $tipe = mysqli_real_escape_string($conn, $_POST['tipe']);
    $sumber = mysqli_real_escape_string($conn, $_POST['sumber']);
    $jumlah = mysqli_real_escape_string($conn, $_POST['jumlah']);
    $keterangan = mysqli_real_escape_string($conn, $_POST['keterangan']);
    $user_id = isset($_SESSION['id']) ? $_SESSION['id'] : 0;
    $id_gudang = 1;
    $tanggal = date('Y-m-d H:i:s');
    
    // Validasi
    if (empty($id_obat) || empty($tipe) || empty($sumber) || empty($jumlah)) {
        echo "<script>alert('Semua field wajib diisi!'); window.history.back();</script>";
        exit;
    }
    
    if ($jumlah <= 0) {
        echo "<script>alert('Jumlah harus lebih dari 0!'); window.history.back();</script>";
        exit;
    }
    
    // Untuk ADJUSTMENT, ambil arah dari form
    $arah_adjustment = '';
    if ($tipe == 'ADJUSTMENT') {
        $arah_adjustment = mysqli_real_escape_string($conn, $_POST['arah']);
        if (empty($arah_adjustment)) {
            echo "<script>alert('Pilih arah adjustment!'); window.history.back();</script>";
            exit;
        }
        // Tambahkan arah ke keterangan untuk tracking
        $keterangan = "[$arah_adjustment] " . $keterangan;
    }
    
    // Cek stok untuk tipe KELUAR atau ADJUSTMENT KURANG
    if ($tipe == 'KELUAR' || ($tipe == 'ADJUSTMENT' && $arah_adjustment == 'KURANG')) {
        $query_stok = "SELECT SUM(jumlah) as total FROM stok WHERE id_obat = '$id_obat' AND id_gudang = '$id_gudang'";
        $result_stok = mysqli_query($conn, $query_stok);
        $data_stok = mysqli_fetch_assoc($result_stok);
        $stok_tersedia = $data_stok['total'] ?? 0;
        
        if ($stok_tersedia < $jumlah) {
            echo "<script>alert('Stok tidak cukup! Stok tersedia: $stok_tersedia'); window.history.back();</script>";
            exit;
        }
    }
    
    // Insert mutasi stok (gunakan kolom yang sudah ada)
    $query_insert = "INSERT INTO mutasi_stok (id_obat, id_gudang, tipe, sumber, jumlah, tanggal, keterangan, id_user)
                     VALUES ('$id_obat', '$id_gudang', '$tipe', '$sumber', '$jumlah', '$tanggal', '$keterangan', '$user_id')";
    
    if (mysqli_query($conn, $query_insert)) {
        // Update stok berdasarkan tipe
        $query_update_stok = "";
        
        if ($tipe == 'KELUAR') {
            // Kurangi stok
            $query_update_stok = "UPDATE stok SET jumlah = jumlah - $jumlah 
                                 WHERE id_obat = '$id_obat' AND id_gudang = '$id_gudang'";
        } elseif ($tipe == 'MASUK') {
            // Tambah stok, cek apakah sudah ada
            $query_stok_check = "SELECT * FROM stok WHERE id_obat = '$id_obat' AND id_gudang = '$id_gudang'";
            $result_stok_check = mysqli_query($conn, $query_stok_check);
            
            if (mysqli_num_rows($result_stok_check) > 0) {
                // Update existing
                $query_update_stok = "UPDATE stok SET jumlah = jumlah + $jumlah 
                                     WHERE id_obat = '$id_obat' AND id_gudang = '$id_gudang'";
            } else {
                // Insert new
                $query_update_stok = "INSERT INTO stok (id_obat, id_gudang, jumlah) 
                                     VALUES ('$id_obat', '$id_gudang', '$jumlah')";
            }
        } elseif ($tipe == 'ADJUSTMENT') {
            // ADJUSTMENT - update stok berdasarkan arah yang dipilih user
            if ($arah_adjustment == 'TAMBAH') {
                // Cek apakah stok sudah ada
                $query_stok_check = "SELECT * FROM stok WHERE id_obat = '$id_obat' AND id_gudang = '$id_gudang'";
                $result_stok_check = mysqli_query($conn, $query_stok_check);
                
                if (mysqli_num_rows($result_stok_check) > 0) {
                    $query_update_stok = "UPDATE stok SET jumlah = jumlah + $jumlah 
                                         WHERE id_obat = '$id_obat' AND id_gudang = '$id_gudang'";
                } else {
                    $query_update_stok = "INSERT INTO stok (id_obat, id_gudang, jumlah) 
                                         VALUES ('$id_obat', '$id_gudang', '$jumlah')";
                }
            } elseif ($arah_adjustment == 'KURANG') {
                $query_update_stok = "UPDATE stok SET jumlah = jumlah - $jumlah 
                                     WHERE id_obat = '$id_obat' AND id_gudang = '$id_gudang'";
            }
        }
        
        if (!empty($query_update_stok) && !mysqli_query($conn, $query_update_stok)) {
            echo "<script>alert('Gagal mengupdate stok!'); window.history.back();</script>";
            exit;
        }
        
        echo "<script>alert('Mutasi stok berhasil ditambahkan!'); window.location='pengeluaranapoteker.php';</script>";
    } else {
        echo "<script>alert('Gagal menambahkan mutasi stok: " . mysqli_error($conn) . "'); window.history.back();</script>";
    }
}
?>